function Figure4E
% This script plots the data from Figure 4E by grouping particle data in
% intervals of 10%.

load('Figure4D_data.mat');
% cs: C3 intensities for spherical particles
% fs: F intensities for spherical particles
% cf: C3 intensities for filaments
% ff: F intensities for filaments

CS = cs; CF = cf;

NS = size(CS,2);
dq = 0.9;
for k = 1:NS/10:NS
  ind = round(k:(k+NS/10-1));
  c = [dq dq dq];
  plot(mean(CS(:,ind),2),'Color',c); hold on;
  dq = dq - 0.1;
end
ylim([-.25 3.5]*1e4);
title('Golbular particles');
xlabel('Time [min]');
ylabel('Average C4 per particle');

NF = size(CF,2); dq = 0.9;
figure;
for k = 1:NF/10:NF
  ind = round(k:(k+NF/10-1));
  c = [dq dq dq];
  plot(mean(CF(:,ind),2),'Color',c); hold on;
  dq = dq - 0.1;
end
ylim([-.25 3.5]*1e4);
title('Filamentous particles');
xlabel('Time [min]');
ylabel('Average C4 per particle');
